//=============================================================================
// Terrorist.
//=============================================================================
class BorderlandsPawn extends HumanMilitary;

var int MaxHealthMark;
var int LevelStrength;

var BLHealthSprite HealthSprite;
var BLLevelSprite LevelSprite;

var(AI) bool bSuicideBombs;
var bool bSuicideBombing;
var bool bHealthSet;

var class<Inventory> DropItem;


function int GetPlayerLevel()
{
 local MSBorderlandsMutator M;
 local int i;
 
 forEach AllActors(class'MSBorderlandsMutator', M)
 {
  if (M != None)
  {
   i = int(M.CurrentLevel);
   break;
  }
 }
 
 return i;
}

function Tick(float deltaTime)
{
	local float        dropPeriod;
	local float        adjustedRate;
	local DeusExPlayer player;
	local name         stateName;
	local vector       loc;
	local bool         bDoLowPriority;
	local bool         bCheckOther;
	local bool         bCheckPlayer;

	player = DeusExPlayer(GetPlayerPawn());

	bDoLowPriority = true;
	bCheckPlayer   = true;
	bCheckOther    = true;
	if (bTickVisibleOnly)
	{
		if (DistanceFromPlayer > 1200)
			bDoLowPriority = false;
		if (DistanceFromPlayer > 2500)
			bCheckPlayer = false;
		if ((DistanceFromPlayer > 600) && (LastRendered() >= 5.0))
			bCheckOther = false;
	}

/*
	if (bDisappear && (InStasis() || (LastRendered() > 5.0)))
	{
		Destroy();
		return;
	}

	if (PrePivotTime > 0)
	{
		if (deltaTime < PrePivotTime)
		{
			PrePivot = PrePivot + (DesiredPrePivot-PrePivot)*deltaTime/PrePivotTime;
			PrePivotTime -= deltaTime;
		}
		else
		{
			PrePivot = DesiredPrePivot;
			PrePivotTime = 0;
		}
	}

	if (bDoLowPriority)
		Super(Pawn).Tick(deltaTime);

	UpdateAgitation(deltaTime);
	UpdateFear(deltaTime);

	AlarmTimer -= deltaTime;
	if (AlarmTimer < 0)
		AlarmTimer = 0;

	if (Weapon != None)
		WeaponTimer += deltaTime;
	else if (WeaponTimer != 0)
		WeaponTimer = 0;

	if ((ReloadTimer > 0) && (Weapon != None))
		ReloadTimer -= deltaTime;
	else
		ReloadTimer = 0;

	if (AvoidWallTimer > 0)
	{
		AvoidWallTimer -= deltaTime;
		if (AvoidWallTimer < 0)
			AvoidWallTimer = 0;
	}

	if (AvoidBumpTimer > 0)
	{
		AvoidBumpTimer -= deltaTime;
		if (AvoidBumpTimer < 0)
			AvoidBumpTimer = 0;
	}

	if (CloakEMPTimer > 0)
	{
		CloakEMPTimer -= deltaTime;
		if (CloakEMPTimer < 0)
			CloakEMPTimer = 0;
	}

	if (TakeHitTimer > 0)
	{
		TakeHitTimer -= deltaTime;
		if (TakeHitTimer < 0)
			TakeHitTimer = 0;
	}

	if (CarcassCheckTimer > 0)
	{
		CarcassCheckTimer -= deltaTime;
		if (CarcassCheckTimer < 0)
			CarcassCheckTimer = 0;
	}

	if (PotentialEnemyTimer > 0)
	{
		PotentialEnemyTimer -= deltaTime;
		if (PotentialEnemyTimer <= 0)
		{
			PotentialEnemyTimer    = 0;
			PotentialEnemyAlliance = '';
		}
	}

	if (BeamCheckTimer > 0)
	{
		BeamCheckTimer -= deltaTime;
		if (BeamCheckTimer < 0)
			BeamCheckTimer = 0;
	}

	if (FutzTimer > 0)
	{
		FutzTimer -= deltaTime;
		if (FutzTimer < 0)
			FutzTimer = 0;
	}

	if (PlayerAgitationTimer > 0)
	{
		PlayerAgitationTimer -= deltaTime;
		if (PlayerAgitationTimer < 0)
			PlayerAgitationTimer = 0;
	}

	if (DistressTimer >= 0)
	{
		DistressTimer += deltaTime;
		if (DistressTimer > FearSustainTime)
			DistressTimer = -1;
	}

	if (bHasCloak)
		EnableCloak(Health <= CloakThreshold);

	if (bAdvancedTactics)
	{
		if ((Acceleration == vect(0,0,0)) || (Physics != PHYS_Walking) ||
		    (TurnDirection == TURNING_None))
		{
			bAdvancedTactics = false;
			if (TurnDirection != TURNING_None)
				MoveTimer -= 4.0;
			ActorAvoiding    = None;
			NextDirection    = TURNING_None;
			TurnDirection    = TURNING_None;
			bClearedObstacle = true;
			ObstacleTimer    = 0;
		}
	}

	if (bOnFire)
	{
		burnTimer += deltaTime;
		if (burnTimer >= BurnPeriod)
			ExtinguishFire();
	}

	if (bDoLowPriority)
	{
		if ((bleedRate > 0) && bCanBleed)
		{
			adjustedRate = (1.0-FClamp(bleedRate, 0.0, 1.0))*1.0+0.1;  // max 10 drops per second
			dropPeriod = adjustedRate / FClamp(VSize(Velocity)/512.0, 0.05, 1.0);
			dropCounter += deltaTime;
			while (dropCounter >= dropPeriod)
			{
				SpurtBlood();
				dropCounter -= dropPeriod;
			}
			bleedRate -= deltaTime/clotPeriod;
		}
		if (bleedRate <= 0)
		{
			dropCounter = 0;
			bleedRate   = 0;
		}
	}
*/

	if (bStandInterpolation)
		UpdateStanding(deltaTime);

	// this is UGLY!


	//WCCC - coincidentally, its un-needed by borderlands.
	/*if (bOnFire && (health > 0))
	{
		stateName = GetStateName();
		if ((stateName != 'Burning') && (stateName != 'TakingHit') && (stateName != 'RubbingEyes'))
			GotoState('Burning');
	}*/
	else
	{
		if (bDoLowPriority)
		{
			// Don't allow radius-based convos to interupt other conversations!
			if ((player != None) && (GetStateName() != 'Conversation') && (GetStateName() != 'FirstPersonConversation'))
				player.StartConversation(Self, IM_Radius);
		}

		if (CheckEnemyPresence(deltaTime, bCheckPlayer, bCheckOther))
			HandleEnemy();
		else
		{
			CheckBeamPresence(deltaTime);
			if (bDoLowPriority || LastRendered() < 5.0)
				CheckCarcassPresence(deltaTime);  // hacky -- may change state!
		}
	}

	// Randomly spawn an air bubble every 0.2 seconds if we're underwater
	if (HeadRegion.Zone.bWaterZone && bSpawnBubbles && bDoLowPriority)
	{
		swimBubbleTimer += deltaTime;
		if (swimBubbleTimer >= 0.2)
		{
			swimBubbleTimer = 0;
			if (FRand() < 0.4)
			{
				loc = Location + VRand() * 4;
				loc.Z += CollisionHeight * 0.9;
				Spawn(class'AirBubble', Self,, loc);
			}
		}
	}

	// Handle poison damage
	UpdatePoison(deltaTime);
}

function DestroyWeapons()
{
 local DeusExWeapon W;
 
 forEach BasedActors(class'DeusExWeapon', W)
 {
  if (!W.IsA('WeaponSuicideBomb')) W.Destroy();
 }
}

function SetUpSuicideBomb()
{
 local WeaponSuicideBomb B;
 
 DestroyWeapons();
 
 GroundSpeed *= 1.333;
 
 B = Spawn(class'WeaponSuicideBomb',,,Location);
 
 B.InitialState = 'Idle2';
 B.GiveTo(Self);
 B.SetBase(Self);
}

function ApplyHealthLevel()
{
 local int i, Result;
 local float F;
 
 if (bHealthSet) return;
 
 if (LevelStrength > 50) LevelStrength = 50;
 
 i = MaxHealthMark;
 f = float(LevelStrength) / 2;
 
 Result = i * f;
 
 if (Result < 25) Result = 10;
 
 BeefHealth(Result);
}

function BeefHealth(int i)
{
 if (bHealthSet) return;
 
 MaxHealthMark = i;
 Health = i;
 
 bHealthSet = True;
 
 //BroadcastMessage("Health Buffed To "$Health$"!");
}

function float ModifyDamage(int Damage, Pawn instigatedBy, Vector hitLocation,
                            Vector offset, Name damageType)
{
	local int   actualDamage;
	local float headOffsetZ, headOffsetY, armOffset;

	/*if (InstigatedBy.IsA('DeusExPlayer'))
	{
	 if (DeusExPlayer(InstigatedBy).InHand.IsA('WeaponCrowbar'))
	 {
	  BeefHealth();
	 }
	 
	 //InformMutator();
	}*/

	actualDamage = Damage;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	// if the pawn is stunned, damage is 4X
	if (bStunned)
		actualDamage *= 4;

	// if the pawn is hit from behind at point-blank range, he is killed instantly
	else if (offset.x < 0)
		if ((instigatedBy != None) && (VSize(instigatedBy.Location - Location) < 64))
			actualDamage  *= 10;

	actualDamage = Level.Game.ReduceDamage(actualDamage, DamageType, self, instigatedBy);

	if (ReducedDamageType == 'All') //God mode
		actualDamage = 0;
	else if (Inventory != None) //then check if carrying armor
		actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);

	// gas, EMP and nanovirus do no damage
	if (damageType == 'TearGas' || damageType == 'EMP' || damageType == 'NanoVirus')
		actualDamage = 0;

	if (damageType == 'Acid') actualDamage = MaxHealthMark / 100;

	return actualDamage;

}

function GenerateTotalHealth()
{
}

function UpdateFire()
{
 local int Dam;
	
	Dam = (250 - MaxHealthMark / LevelStrength) / 5;

	if (Dam < 0) Dam = 0;

	// continually burn and do damage
	Health -= Dam * LevelStrength / 10;
	GenerateTotalHealth();
	if (Health <= 0)
	{
		TakeDamage(10, FirstPlayer(), Location, vect(0,0,0), 'Burned');
		ExtinguishFire();
	}
	UpdateHealthSprite();
	SpawnDamageNumbers(Dam, True, False, 'Burned');
}

function EHitLocation HandleDamage(int actualDamage, Vector hitLocation, Vector offset, name damageType)
{
	local EHitLocation hitPos;
	local float        headOffsetZ, headOffsetY, armOffset;

	local int TotalDamage;
	local bool bCrit, bReduced;

	// calculate our hit extents
	headOffsetZ = CollisionHeight * 0.7;
	headOffsetY = CollisionRadius * 0.3;
	armOffset   = CollisionRadius * 0.35;

	hitPos = HITLOC_None;

	if (actualDamage > 0)
	{
		if (offset.z > headOffsetZ)		// head
		{
			// narrow the head region
			if ((Abs(offset.x) < headOffsetY) || (Abs(offset.y) < headOffsetY))
			{
				// don't allow headshots with stunning weapons
				if ((damageType == 'Stunned') || (damageType == 'KnockedOut'))
					TotalDamage = 0;
				else
				{
					bCrit = True;
					TotalDamage = ActualDamage * 2;
				}
				if (offset.x < 0.0)
					hitPos = HITLOC_HeadBack;
				else
					hitPos = HITLOC_HeadFront;
			}
			else  // sides of head treated as torso
			{
				TotalDamage = ActualDamage;
				
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
			}
		}
		else						// arms and torso
		{
				TotalDamage = ActualDamage;
				if (offset.x < 0.0)
					hitPos = HITLOC_TorsoBack;
				else
					hitPos = HITLOC_TorsoFront;
		}
	}

	if (TotalDamage > 0) SpawnDamageNumbers(TotalDamage, bCrit, bReduced, damageType);

	Health -= TotalDamage;

	if (Health < MaxHealthMark * 0.25 && bSuicideBombs && !bSuicideBombing)
	{
	 bSuicideBombing = True;
	 SetUpSuicideBomb();
	}

	GenerateTotalHealth();


	//InformMutator();
	
	UpdateHealthSprite();
	
	return hitPos;
}

function SpawnDamageNumbers(int Dam, bool bCrit, bool bReduced, name Type)
{
 local String S, CurS, Color;
 local int i, j, k, l, Length;
 
 S = String(Dam);
 
 if (Dam > 9999) Dam = 9999;
 
 Length = Len(S);
 
 if (Length == 1)
 {
  i = Dam;
 }
 if (Length == 2)
 {
  j = int( LeftTrim(S, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 3)
 {
  k = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 if (Length == 4)
 {
  l = int( LeftTrim(S, 1) );
  j = int( MidTrim(S, 2, 1) );
  k = int( MidTrim(S, 1, 1) );
  i = int( RightTrim(S, 1) );
 }
 
 if (bCrit) Color = "Red";
 if (bReduced && !bCrit) Color = "Gray";
 if (!bReduced && !bCrit) Color = "White";
 
 if (Type == 'Shocked' || Type == 'EMP') Color = "Blue";
 if (Type == 'Acid') Color = "Green";
 if (Type == 'Exploded') Color = "Yellow";
 if (Type == 'Burned' || Type == 'Flamed') Color = "Orange";
 
 SpawnNumbers(i, j, k, l, Color, Len(S));
}

function DeusExPlayer FirstPlayer()
{
 local DeusExPlayer Play, Best;
 local float BestDist, Current;
 
 forEach allActors(class'DeusExPlayer', Play)
 {
  Current = VSize(Location - Play.Location);
  
   if (Best == None || Current < BestDist)
   {
    Best = Play;
    BestDist = Current;
   }
 }
 
 return Best;
}



final function string RightTrim(String A, int B)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Right(s, B);
 
 n = s2;
 
 return n;
}

final function string MidTrim(string A, int B, optional int C)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Mid(s, B, C);
 
 n = s2;
 
 return n;
}

final function string LeftTrim(string A, int B)
{
 local string S, s2;
 local string n;
 
 s = A;
 s2 = Left(s, B);
 
 n = s2;
 
 return n;
}



function SpawnNumbers(int i, int j, int k, int l, string Color, int Length)
{
 local BLNumberSprite N;
 local Vector V, O;
 
 //BroadcastMessage(Length);
 
 //BroadcastMessage(i$j$k$l);
 
 //if (i == 0) i = 1;
 
 V = (vect(0,0,1) * CollisionHeight * 1.2) + ((vect(0,1,0) >> FirstPlayer().Rotation) * Rand(10)) + (vect(0,0,1) * Rand(10));
 
 O = vect(0,-4,0) >> FirstPlayer().Rotation;
 
 N = Spawn(class'BLNumberSprite', Self,,Location + V + O);
 N.Color = Color;
 N.Number = i;
 N.UpdateTexture();
 
 if (Length > 1)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 2));
  N.Color = Color;
  N.Number = j;
  N.UpdateTexture();
 }
 
 if (Length > 2)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 3));
  N.Color = Color;
  N.Number = k;
  N.UpdateTexture();
 }
 
 if (Length > 3)
 {
  N = Spawn(class'BLNumberSprite', Self,,Location + V + (O * 4));
  N.Color = Color;
  N.Number = l;
  N.UpdateTexture();
 }
}

function UpdateHealthSprite()
{
 if (HealthSprite == None) SpawnHealthSprite();
 
 HealthSprite.UpdateTexture(Health, MaxHealthMark);
}

function SpawnHealthSprite()
{
 HealthSprite = Spawn(class'BLHealthSprite', Self);
 HealthSprite.SetTimer(0.02, True);

 LevelSprite = Spawn(class'BLLevelSprite', Self);
 LevelSprite.CurrentLevel = LevelStrength;
 LevelSprite.UpdateTexture();
 LevelSprite.SetTimer(0.02, True);
}

function TakeDamage(int D, Pawn Inst, vector H, vector M, name T)
{
 Super.TakeDamage(D, Inst, H, M, T);
}

defaultproperties
{
     MinHealth=0.000000
     CarcassType=Class'DeusEx.TerroristCarcass'
     WalkingSpeed=0.296000
     AvoidAccuracy=0.100000
     CrouchRate=0.250000
     SprintRate=0.250000
     walkAnimMult=0.780000
     GroundSpeed=200.000000
     LevelStrength=1
     Health=75
     HealthHead=75
     HealthTorso=75
     HealthLegLeft=75
     HealthLegRight=75
     HealthArmLeft=75
     HealthArmRight=75
     MaxHealthMark=75
     Texture=Texture'DeusExItems.Skins.PinkMaskTex'
     Mesh=LodMesh'DeusExCharacters.GM_Jumpsuit'
     MultiSkins(0)=Texture'DeusExCharacters.Skins.TerroristTex0'
     MultiSkins(1)=Texture'DeusExCharacters.Skins.TerroristTex2'
     MultiSkins(2)=Texture'DeusExCharacters.Skins.TerroristTex1'
     MultiSkins(3)=Texture'DeusExCharacters.Skins.TerroristTex0'
     MultiSkins(4)=Texture'DeusExCharacters.Skins.TerroristTex0'
     MultiSkins(5)=Texture'DeusExItems.Skins.GrayMaskTex'
     MultiSkins(6)=Texture'DeusExCharacters.Skins.GogglesTex1'
     MultiSkins(7)=Texture'DeusExItems.Skins.PinkMaskTex'
     CollisionRadius=20.000000
     CollisionHeight=47.500000
     BindName="Terrorist"
     FamiliarName="Terrorist"
     UnfamiliarName="Terrorist"

     bReactFutz=True
     bReactPresence=True
     bReactLoudNoise=True
     bReactAlarm=True
     bReactShot=True
     bReactCarcass=False
     bReactDistress=False
     bReactProjectiles=True

}
